/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzacraft.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzacraft.blockentity.PizzaHungerSystem;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.items.KnifeItem;
import com.tiviacz.pizzacraft.items.PizzaPeelItem;
import com.tiviacz.pizzacraft.util.FoodUtils;
import com.tiviacz.pizzacraft.util.RenderUtils;
import com.tiviacz.pizzacraft.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class PizzaBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BITES = BlockStateProperties.f_61412_;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0)};

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)BITES)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(3) == 0 && level.m_7702_(pos) instanceof PizzaBlockEntity && ((PizzaBlockEntity)level.m_7702_(pos)).isFresh()) {
            double[] particlePos = RenderUtils.getPosRandomAboveBlockHorizontal(level, pos);
            for (int i = 0; i < 2; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particlePos[0], (double)pos.m_123342_() + 0.4, particlePos[1], 0.0, 0.025, 0.0);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, particlePos[0], (double)pos.m_123342_() + 0.3, particlePos[1], 0.0, 3.0 + rand.m_188500_(), 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (level.m_7702_(pos) instanceof PizzaBlockEntity) {
            if (itemstack.m_41720_() instanceof PizzaPeelItem && (Integer)state.m_61143_((Property)BITES) == 0) {
                ItemStack stack = this.m_5456_().m_7968_();
                ((PizzaBlockEntity)level.m_7702_(pos)).writeToItemStack(stack);
                if (!level.f_46443_) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() instanceof KnifeItem) {
                int i = (Integer)state.m_61143_((Property)BITES);
                ItemStack stack = ((Item)ModItems.PIZZA_SLICE.get()).m_7968_();
                PizzaBlockEntity tile = (PizzaBlockEntity)level.m_7702_(pos);
                tile.writeToSliceItemStack(stack, i);
                if (i < 6) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
                } else {
                    level.m_7471_(pos, false);
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
                tile.requestModelDataUpdate();
                itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_() && player.m_6047_()) {
                ((PizzaBlockEntity)level.m_7702_(pos)).openGUI(player, (PizzaBlockEntity)level.m_7702_(pos), pos);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.eatPizza((LevelAccessor)level, pos, state, player) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_()) {
            return InteractionResult.CONSUME;
        }
        return this.eatPizza((LevelAccessor)level, pos, state, player);
    }

    private InteractionResult eatPizza(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            blockEntity.requestModelDataUpdate();
        }
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        int i = (Integer)state.m_61143_((Property)BITES);
        if (blockEntity instanceof PizzaBlockEntity) {
            ((PizzaBlockEntity)blockEntity).setHungerAndSaturationRefillment();
            for (Pair<MobEffectInstance, Float> pair : ((PizzaBlockEntity)blockEntity).getEffects()) {
                if (level.m_5776_() || pair.getFirst() == null || !(level.m_213780_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            player.m_36324_().m_38707_(((PizzaBlockEntity)blockEntity).getHungerForSlice(i), ((PizzaBlockEntity)blockEntity).getSaturationForSlice());
        }
        if (i < 6) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.m_7702_(pos) instanceof PizzaBlockEntity && stack.m_41783_() != null) {
            ((PizzaBlockEntity)level.m_7702_(pos)).readFromStack(stack);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (world.m_7702_(pos) instanceof PizzaBlockEntity) {
            ItemStack stack = this.m_7397_(world, pos, state);
            ((PizzaBlockEntity)world.m_7702_(pos)).writeToItemStack(stack);
            return stack;
        }
        return this.getCloneItemStack(state, target, world, pos, player);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60831_((BlockGetter)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        return (7 - (Integer)blockState.m_61143_((Property)BITES)) * 2;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PizzaBlockEntity(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        PizzaBlock.addInformationForPizza(stack, tooltip);
    }

    public static void addInformationForPizza(ItemStack stack, List<Component> tooltip) {
        ItemStackHandler handler = Utils.createHandlerFromStack(stack, 9);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            MutableComponent translatedText = Component.m_237115_((String)stackInSlot.m_41778_());
            MutableComponent textComponent = Component.m_237113_((String)(stackInSlot.m_41613_() > 1 ? stackInSlot.m_41613_() + "x " : ""));
            tooltip.add((Component)textComponent.m_7220_((Component)translatedText).m_130940_(ChatFormatting.BLUE));
        }
        PizzaHungerSystem instance = new PizzaHungerSystem(handler);
        tooltip.add((Component)Component.m_237110_((String)"information.pizzacraft.hunger", (Object[])new Object[]{FoodUtils.getHungerForSlice(instance.getHunger(), false), instance.getHunger() % 7 != 0 ? " (+" + instance.getHunger() % 7 + ")" : "", instance.getHunger()}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"information.pizzacraft.saturation", (Object[])new Object[]{Float.valueOf((float)((double)Math.round((double)(instance.getSaturation() / 7.0f) * 100.0) / 100.0)), Float.valueOf((float)((double)Math.round((double)instance.getSaturation() * 100.0) / 100.0))}).m_130940_(ChatFormatting.BLUE));
        if (!instance.getEffects().isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"information.pizzacraft.effects").m_130940_(ChatFormatting.GOLD));
            for (Pair<MobEffectInstance, Float> pair : instance.getEffects()) {
                tooltip.add((Component)Component.m_237115_((String)((MobEffectInstance)pair.getFirst()).m_19576_()).m_130940_(((MobEffectInstance)pair.getFirst()).m_19544_().m_19483_().m_19497_()));
            }
        }
    }
}

